import pygame
""" Carrega as Imagens """
def carregar_imagem(caminho: str, altura_escala: int | None=None) -> pygame.Surface:
    " Calcular Oroporção "
    imagem = pygame.image.load(caminho).convert_alpha()
    if altura_escala is None: 
        return imagem 
    largura_atual, altura_atual = imagem.get_size()
    proporcao = altura_escala / altura_atual
    novo_tamnho = (int(largura_atual * proporcao), int(altura_atual * proporcao))
    return pygame.transform.smoothscale(imagem, novo_tamnho)
